/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class CopierObjet {
    private static Logger log = Logger.getLogger(CopierObjet.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, long l2, String string) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                ResultatInfo resultatInfo = new ResultatInfo("Copie de l'objet \"" + string + "\" (C_CopyObject)");
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                resultatInfo.setInfos(linkedHashMap);
                try {
                    CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
                    cK_ATTRIBUTEArray[0].type = 3L;
                    cK_ATTRIBUTEArray[0].pValue = ("Copie de " + string).toCharArray();
                    long l3 = pKCS11.C_CopyObject(l, l2, cK_ATTRIBUTEArray);
                    linkedHashMap.put("Identifiant de l'objet", Long.toString(l3));
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultatInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                }
                return resultatInfo;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(20, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(20, "Une erreur inattendue est survenue");
        }
    }
}

